<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Models\City;
use App\Models\Country;
use App\Models\Therapist;
use App\Models\State;
use App\Models\TherapistCategory;

class WebAPIController extends Controller
{
    public function __construct()
    {
        // $this->middleware('auth');
    }

    public function getCountries(Request $request){
        $countries = WebAPIGeneralController::getCountries($request);
        $response = generateResponse($countries,true,"Countries Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getStates(Request $request){
        $request->validate(['country_id' => 'exists:countries,id']);
        $states = WebAPIGeneralController::getStates($request);
        $response = generateResponse($states,true,"States Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getEvents(Request $request){
        $events = WebAPIGeneralController::searchEvents($request);
        $response = generateResponse($events,true,"Events Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getTestimonials(Request $request){
        $testimonials = WebAPIGeneralController::getTestimonials($request);
        $response = generateResponse($testimonials,true,"Testimonials Fetched Successfully",null,'collection');
        return response()->json($response);

    }


    public function getPosts(Request $request){
        $posts = WebAPIGeneralController::searchPosts($request);
        $response = generateResponse($posts,true,"Posts Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getArchives(Request $request){
        $archives = WebAPIGeneralController::searchArchives($request);
        $response = generateResponse($archives,true,"Archives Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getBroadcasts(Request $request){
        $broadcasts = WebAPIGeneralController::searchBroadcasts($request);
        $response = generateResponse($broadcasts,true,"Broadcasts Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getPodcasts(Request $request){
        $podcasts = WebAPIGeneralController::searchPodcasts($request);
        $response = generateResponse($podcasts,true,"Podcasts Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getServices(Request $request){
        $services = WebAPIGeneralController::searchServices($request);
        $response = generateResponse($services,true,"Services Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getTherapists(Request $request){
        // $request->validate(['country_id' => 'exists:countries,id']);
        $therapists = WebAPIGeneralController::searchTherapists($request);
        $response = generateResponse($therapists,true,"Therapists Fetched Successfully",null,'collection');
        return response()->json($response);
    }


    public function getTherapistReviews(Request $request,$user_name){
        $therapist_reviews = WebAPIGeneralController::searchTherapistReviews($request,$user_name);
        $response = generateResponse($therapist_reviews,true,"Therapist Reviews Fetched Successfully",null,'collection');
        return response()->json($response);
    }
    public function getTherapistCommunityReviews(Request $request,$user_name){
        $therapist_community_reviews = WebAPIGeneralController::searchTherapistCommunityReviews($request,$user_name);
        $response = generateResponse($therapist_community_reviews,true,"TherapistCommunity Reviews Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getTherapistCommunitys(Request $request){
        // $request->validate(['country_id' => 'exists:countries,id']);
        $therapist_communitys = WebAPIGeneralController::searchTherapistCommunitys($request);
        $response = generateResponse($therapist_communitys,true,"TherapistCommunitys Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getTherapistCommunityCategories(Request $request){
        $therapist_community_categories = WebAPIGeneralController::getTherapistCommunityCategories($request);
        $response = generateResponse($therapist_community_categories,true,"TherapistCommunity Categories Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getBlogCategories(Request $request){
        $blog_categories = WebAPIGeneralController::getBlogCategories($request);
        $response = generateResponse($blog_categories,true,"Blog Categories Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getTags(Request $request){
        $tags = WebAPIGeneralController::getTags($request);
        $response = generateResponse($tags,true,"Tags Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getServiceCategories(Request $request){
        $service_categories = WebAPIGeneralController::getServiceCategories($request);
        $response = generateResponse($service_categories,true,"ServiceCategories Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getArchiveCategories(Request $request){
        $archive_categories = WebAPIGeneralController::getArchiveCategories($request);
        $response = generateResponse($archive_categories,true,"Blog Categories Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getTherapistCategories(Request $request){
        $therapist_categories = WebAPIGeneralController::getTherapistCategories($request);
        $response = generateResponse($therapist_categories,true,"Therapist Categories Fetched Successfully",null,'collection');
        return response()->json($response);
    }
    public function getFeaturedTherapistCategories(Request $request){
        $featured_therapist_categories = WebAPIGeneralController::getFeaturedTherapistCategories($request);
        $response = generateResponse($featured_therapist_categories,true,"Therapist Categories Fetched Successfully",null,'collection');
        return response()->json($response);
    }


    public function getCities(Request $request){
        $request->validate(['state_id' => 'exists:states,id']);
        $cities = WebAPIGeneralController::getCities($request);
        $response = generateResponse($cities,true,"Cities Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getFeaturedTags(Request $request){
        $featured_tags = WebAPIGeneralController::getFeaturedTags($request);
        $response = generateResponse($featured_tags,true,"Featured Tags Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getFeaturedTherapists(Request $request){
        $featured_therapists = WebAPIGeneralController::getFeaturedTherapists($request);
        $response = generateResponse($featured_therapists,true,"Featured Therapists Fetched Successfully",null,'collection');
        return response()->json($response);
    }
    public function getTopRatedTherapists(Request $request){
        $top_rated_therapists = WebAPIGeneralController::getTopRatedTherapists($request);
        $response = generateResponse($top_rated_therapists,true,"Featured Therapists Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getPremiumTherapists(Request $request)
    {
        $premium_therapistes = WebAPIGeneralController::getPremiumTherapists($request);
        $response = generateResponse($premium_therapistes,true,"Premium Therapists Fetched Successfully",null,'collection');
        return response()->json($response);
    }
    public function getFeaturedEvents(Request $request){
        $featured_events = WebAPIGeneralController::getFeaturedEvents($request);
        $response = generateResponse($featured_events,true,"Featured Events Fetched Successfully",null,'collection');
        return response()->json($response);
    }
    public function getSpotlightTherapists(Request $request){
        $spotlight_therapists = WebAPIGeneralController::getSpotlightTherapists($request);
        $response = generateResponse($spotlight_therapists,true,"Spotlight Therapists Fetched Successfully",null,'collection');
        return response()->json($response);
    }
    public function getFeaturedTherapistCommunitys(Request $request){
        $featured_therapist_communitys = WebAPIGeneralController::getFeaturedTherapistCommunitys($request);
        $response = generateResponse($featured_therapist_communitys,true,"Featured TherapistCommunitys Fetched Successfully",null,'collection');
        return response()->json($response);
    }
    public function getFaqs(Request $request){
        $faqs = WebAPIGeneralController::getFaqs($request);
        $response = generateResponse($faqs,true,"FAQS Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getTrendingCommunityPosts(Request $request){
        $communit_posts = WebAPIGeneralController::getTrendingCommunityPosts($request);
        $response = generateResponse($communit_posts,true,"Communit_posts Fetched Successfully",null,'collection');
        return response()->json($response);
    }

}
